﻿//
// The custom dial pad is use to change the default behavour of the dial pad under voxco.agent.
//  
// This example will show you how to create a custom diap pad to do a click on dial on a per project basis . 
//
//  m_catiproject   :  vector that contains the click on dial projects id 
//  m_DialPad       :  Dial pad instance of voxco.agent. This instance is reponsable of showing the dial pad 
//
//
//  The easy way to find the cati project id is to look in the voxco.agent log and locate the follwing information 
//
//      2016/11/22|15:56:07|Info|3| [Agent 'bp1' (Id. 5700)] - Pronto NO: 3 
//      2016/11/22|15:56:07|Info|3| [Agent 'bp1' (Id. 5700)] - Project: 6005; Pronto Module 6010, ModuleB 
//      2016/11/22|15:56:07|Info|3| [Agent 'bp1' (Id. 5700)] - Project: 6005; Cati Module 6007, CatiB 
//
//  In this example to cati project id is:  6007 
//


var CustomDialPad = {

    m_currentCatiProject: "",
    m_catiproject: ["6007"],
    m_DialPad: null,


    //
    //  the init fonction is called by voxco.agent only if the CustomDialPad parameter is set to true in the app.conf. This function 
    //  intialize the call back to call on specific events.
    //
    //      onCall: called when the agent click the dial button. In the script example, we send the dial request to pronto server without any validation. The phone number sent is the one showed on dial pad  
    //      onTimeout: called when timeout expired  for the click on dial.
    //      onHide :  called when the dial pad is hidden from the voxco.agent desktop
    //      onClose:  called when voxco.agent close the dialpad either by pressing the close button or when the dial is completed by pronto server.
    //
    init: function (userid) {

        //
        //  The differed init is to let enough time of the system to get the project setting ... this will change in the next release of voxco.agent to avoid timing issue
        //  between custom dial pad and the voxco.agent core system.
        //
        setTimeout(function () { CustomDialPad.defferedInit(userid) }, 1000);
    },


    defferedInit: function (userid) {

        //
        //  getting the dialpad instance
        //
        if (CustomDialPad.m_DialPad == undefined || CustomDialPad.m_DialPad == null)
            CustomDialPad.m_DialPad = gClassManager.getManualDialing();

        //
        //  getting the cati project selected by the agent 
        //
        CustomDialPad.m_currentCatiProject = AgentAssignment.getCatiId();
        if (CustomDialPad.find() == false) {
            CustomDialPad._debug("CustomDialPad.init> This " + CustomDialPad.m_currentCatiProject + " cati project will NOT use the dial on click functionality ... User id " + userid, true);
            CustomDialPad.m_DialPad.init(userid, null);
            return;
        }


        CustomDialPad._debug("CustomDialPad.init> This " + CustomDialPad.m_currentCatiProject + " cati project will use the dial on click function ... User id " + userid, true);

        //
        //  Intialize the call back to be overloaded by the custom dial pad. 
        //  onTimeout: if the timeout is set in the app.config <DialPadDialingTimeout> , at the expiration we will apply the onCall function 
        //
        var userdefineCallback = {};
        userdefineCallback["onCall"] = CustomDialPad.onCall;
        userdefineCallback["onTimeout"] = CustomDialPad.onCall;

       
        //
        //  need to intialize the callback and the dial pad instance ... This function is mandatory
        //
        CustomDialPad.m_DialPad.init(userid, userdefineCallback);
        return;

    },


    find: function () {
        var bfound = false;
        var length = CustomDialPad.m_catiproject.length;
        for (iIndx = 0 ; iIndx < length ; iIndx++) {
            var project = CustomDialPad.m_catiproject[iIndx];
            if (project == CustomDialPad.m_currentCatiProject) {
                bfound = true;
                break;
            }
        }

        return bfound;
    },

    _debug: function (message, bForward) {

        try {

            if (typeof console == "object")
                console.log("debug: " + message);

            if (typeof debug != "function")
                return;

            if (typeof bForward != "boolean" || bForward == false)
                return;

            //
            //  Log the trace on server side ...
            // 
            debug(message);
        }
        catch (e) {

        }

        return;
    },

    Disconnect: function () {
        CustomDialPad.m_DialPad.Disconnect();
    },

    //
    //  onCall : callback function called when the agent press the dial button.
    //  number : not used 
    //
    //  CustomDialPad.m_DialPad.Send(true) when called , voxco.agent send the dial request to prontoserver
    //
    onCall: function (number) {
        var result = CustomDialPad.m_DialPad.Send(true);
    },


    //
    //  onTimeout: called when the dial button is not press after a certain amount of time. See the parameter DialPadDialingTimeout
    //  in the app.config file
    //
    onTimeout: function () {
        CustomDialPad._debug("received on timeout...");
    },

    onHide: function () {
        CustomDialPad._debug("received on hide...");
    },


    onClose: function () {
        CustomDialPad._debug("received on close..");
    },

    onCallableNumber: function (number) {
    }
};


gCustomDialPad = CustomDialPad;



